--
-- TUC Voting System Database Schema
--
-- Database: `tuc_voting_db`
--

-- --------------------------------------------------------

--
-- Table structure for table `users` (Admin Accounts)
--
CREATE TABLE `users` (
  `id` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `full_name` VARCHAR(255) NOT NULL,
  `email` VARCHAR(255) NOT NULL UNIQUE,
  `password` VARCHAR(255) NOT NULL,
  `role` ENUM('super_admin', 'normal_admin') NOT NULL DEFAULT 'normal_admin',
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `users`
--
-- Default Super Admin: email='admin@tuc.com', password='admin123' (Hashed: $2y$10$8H7619H8W8I8yqv4kezc5eoFwlsXXUoOgQdkea1Zz.Xo0TobOgGNG)
--
INSERT INTO `users` (`full_name`, `email`, `password`, `role`) VALUES
('Super Admin', 'admin@tuc.com', '$2y$10$8H7619H8W8I8yqv4kezc5eoFwlsXXUoOgQdkea1Zz.Xo0TobOgGNG', 'super_admin');

-- --------------------------------------------------------

--
-- Table structure for table `voters`
--
CREATE TABLE `voters` (
  `id` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `staff_id` VARCHAR(50) NOT NULL UNIQUE,
  `full_name` VARCHAR(255) NOT NULL,
  `department` VARCHAR(255) NOT NULL,
  `password` VARCHAR(255) NOT NULL,
  `has_voted` TINYINT(1) NOT NULL DEFAULT 0,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `voters`
--
-- Default Voter: staff_id='VOTER001', password='TUC2025' (Hashed: $2y$10$xcui0kE4CtS/OO.nRbRkbeJRFfAfeCqcx5LFRw9KqvyXSL8O9z00O)
--
INSERT INTO `voters` (`staff_id`, `full_name`, `department`, `password`) VALUES
('VOTER001', 'Sample Voter One', 'IT Department', '$2y$10$xcui0kE4CtS/OO.nRbRkbeJRFfAfeCqcx5LFRw9KqvyXSL8O9z00O'),
('VOTER002', 'Sample Voter Two', 'HR Department', '$2y$10$xcui0kE4CtS/OO.nRbRkbeJRFfAfeCqcx5LFRw9KqvyXSL8O9z00O');

-- --------------------------------------------------------

--
-- Table structure for table `positions`
--
CREATE TABLE `positions` (
  `id` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `position_name` VARCHAR(255) NOT NULL UNIQUE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `positions`
--
INSERT INTO `positions` (`position_name`) VALUES
('President'),
('Vice President'),
('Secretary');

-- --------------------------------------------------------

--
-- Table structure for table `candidates`
--
CREATE TABLE `candidates` (
  `id` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `position_id` INT(11) NOT NULL,
  `candidate_name` VARCHAR(255) NOT NULL,
  `photo` VARCHAR(255) DEFAULT NULL, -- Path to the candidate's photo
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`position_id`) REFERENCES `positions`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `candidates`
--
INSERT INTO `candidates` (`position_id`, `candidate_name`, `photo`) VALUES
(1, 'Alice Johnson', 'default.png'),
(1, 'Bob Smith', 'default.png'),
(2, 'Charlie Brown', 'default.png'),
(3, 'Diana Prince', 'default.png');

-- --------------------------------------------------------

--
-- Table structure for table `votes`
--
CREATE TABLE `votes` (
  `id` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `voter_id` INT(11) NOT NULL,
  `position_id` INT(11) NOT NULL,
  `candidate_id` INT(11) NOT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY `voter_position_unique` (`voter_id`, `position_id`), -- Ensures one vote per position per voter
  FOREIGN KEY (`voter_id`) REFERENCES `voters`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`position_id`) REFERENCES `positions`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`candidate_id`) REFERENCES `candidates`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `settings` (For common password and other global settings)
--
CREATE TABLE `settings` (
  `setting_key` VARCHAR(50) NOT NULL PRIMARY KEY,
  `setting_value` TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `settings`
--
-- Removed common password hash as voters will now have unique passwords.
