<?php
// Main Voting Page
require_once '../includes/header.php';
check_voter_login();

$voter_id = $_SESSION['voter_id'];
$message = '';
$show_summary = false;
$summary_votes = [];

// Check if voter has already voted
$sql_check = "SELECT has_voted FROM voters WHERE id = ?";
if ($stmt_check = $conn->prepare($sql_check)) {
    $stmt_check->bind_param("i", $voter_id);
    $stmt_check->execute();
    $stmt_check->bind_result($has_voted);
    $stmt_check->fetch();
    $stmt_check->close();
}

// ----------------------------
// 🟦 IF ALREADY VOTED → SHOW SUMMARY
// ----------------------------
if ($has_voted == 1) {
    $show_summary = true;

    $sql_summary = "
        SELECT p.position_name, c.candidate_name, c.photo 
        FROM votes v
        JOIN candidates c ON v.candidate_id = c.id
        JOIN positions p ON v.position_id = p.id
        WHERE v.voter_id = ?
        ORDER BY p.id ASC
    ";
    if ($stmt_sum = $conn->prepare($sql_summary)) {
        $stmt_sum->bind_param("i", $voter_id);
        $stmt_sum->execute();
        $result = $stmt_sum->get_result();
        while ($row = $result->fetch_assoc()) {
            $summary_votes[] = $row;
        }
        $stmt_sum->close();
    }
}

// ----------------------------
// 🟩 PROCESS VOTE SUBMISSION
// ----------------------------
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_vote'])) {
    $conn->begin_transaction();
    $all_ok = true;

    $sql_insert_vote = "INSERT INTO votes (voter_id, position_id, candidate_id) VALUES (?, ?, ?)";
    $stmt_insert = $conn->prepare($sql_insert_vote);

    foreach ($_POST as $key => $value) {
        if (strpos($key, "position_") === 0) {
            $position_id = (int)substr($key, 9);
            $candidate_id = (int)$value;

            if ($position_id > 0 && $candidate_id > 0) {
                $stmt_insert->bind_param("iii", $voter_id, $position_id, $candidate_id);
                if (!$stmt_insert->execute()) {
                    $all_ok = false;
                    break;
                }
            }
        }
    }
    $stmt_insert->close();

    if ($all_ok) {
        // Mark voter as voted
        $sql_mark = "UPDATE voters SET has_voted = 1 WHERE id = ?";
        if ($stmt_m = $conn->prepare($sql_mark)) {
            $stmt_m->bind_param("i", $voter_id);
            if ($stmt_m->execute()) {
                $conn->commit();

                // Now fetch vote summary to display immediately
                $show_summary = true;

                $sql_summary = "
                    SELECT p.position_name, c.candidate_name, c.photo 
                    FROM votes v
                    JOIN candidates c ON v.candidate_id = c.id
                    JOIN positions p ON v.position_id = p.id
                    WHERE v.voter_id = ?
                    ORDER BY p.id ASC
                ";
                if ($stmt_sum = $conn->prepare($sql_summary)) {
                    $stmt_sum->bind_param("i", $voter_id);
                    $stmt_sum->execute();
                    $result = $stmt_sum->get_result();
                    while ($row = $result->fetch_assoc()) {
                        $summary_votes[] = $row;
                    }
                    $stmt_sum->close();
                }

            } else {
                $conn->rollback();
                $message = '<div class="alert alert-danger">Error finalizing vote.</div>';
            }
            $stmt_m->close();
        }
    } else {
        $conn->rollback();
        $message = '<div class="alert alert-danger">Error submitting vote. Check selections.</div>';
    }
}

// ----------------------------
// 🟨 SUMMARY PAGE IF ALREADY VOTED
// ----------------------------
if ($show_summary):
?>

<h3 class="text-center mt-4">Your Vote Summary</h3>
<p class="text-center text-muted mb-4">Below are the candidates you selected.</p>

<div class="row justify-content-center">
<?php if (empty($summary_votes)): ?>
    <div class="col-12">
        <div class="alert alert-warning text-center">No vote records found.</div>
    </div>
<?php else: ?>
    <?php foreach ($summary_votes as $vote): ?>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <img src="../uploads/candidate_photos/<?php echo htmlspecialchars($vote['photo']); ?>"
                         class="img-fluid rounded-circle mb-3"
                         style="width: 110px; height: 110px; object-fit: cover;" />

                    <h5 class="card-title mb-1"><?php echo htmlspecialchars($vote['candidate_name']); ?></h5>
                    <p class="text-muted"><?php echo htmlspecialchars($vote['position_name']); ?></p>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
<?php endif; ?>
</div>

<div class="text-center mt-4 mb-5">
    <a href="logout.php" class="btn btn-lg btn-danger">LOGOUT</a>
</div>

<?php
require_once '../includes/footer.php';
exit;
endif;

// ----------------------------
// 🟦 NORMAL VOTING FORM (IF NOT VOTED)
// ----------------------------

// Fetch positions & candidates
$positions = [];
$sql_positions = "SELECT id, position_name FROM positions ORDER BY id ASC";
$rpos = $conn->query($sql_positions);
while ($rp = $rpos->fetch_assoc()) {
    $positions[$rp['id']] = ["name" => $rp['position_name'], "candidates" => []];
}

$sql_candidates = "SELECT id, position_id, candidate_name, photo FROM candidates ORDER BY position_id, candidate_name ASC";
$rcand = $conn->query($sql_candidates);
while ($c = $rcand->fetch_assoc()) {
    $positions[$c['position_id']]['candidates'][] = $c;
}
?>

<style>
    .candidate-card {
        border: 2px solid #e9ecef;
        transition: 0.3s;
    }
    .candidate-card.selected {
        border-color: #16a34a !important;
        box-shadow: 0 0 15px rgba(16,163,74,0.4);
        background: #e6ffe6;
    }
</style>

<h4 class="text-center">Welcome, <?php echo htmlspecialchars($_SESSION['voter_name']); ?>!</h4>
<p class="text-center text-muted mb-4">Select one candidate per position.</p>

<?php echo $message; ?>

<form method="POST">
<div class="row">

<?php foreach ($positions as $pid => $pos): ?>
    <div class="col-lg-12 mb-4">
        <div class="card shadow-sm">
            <div class="card-body">
                <h4 class="text-primary"><?php echo htmlspecialchars($pos['name']); ?></h4>

                <div class="row mt-3">
                    <?php if (empty($pos['candidates'])): ?>
                        <div class="col-12">
                            <div class="alert alert-info">No candidates available.</div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($pos['candidates'] as $c): ?>
                            <div class="col-md-4 mb-4">
                                <label class="w-100">
                                    <div class="card candidate-card">
                                        <div class="card-body text-center">
                                            <img src="../uploads/candidate_photos/<?php echo htmlspecialchars($c['photo']); ?>"
                                                 class="img-fluid rounded-circle mb-3"
                                                 style="width:100px;height:100px;object-fit:cover;" />

                                            <h5><?php echo htmlspecialchars($c['candidate_name']); ?></h5>

                                            <input type="radio"
                                                name="position_<?php echo $pid; ?>"
                                                value="<?php echo $c['id']; ?>"
                                                class="d-none candidate-radio"
                                                required>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
<?php endforeach; ?>

<div class="col-12 text-center mt-4 mb-5">
    <button type="submit" name="submit_vote" class="btn btn-success btn-lg">SUBMIT MY VOTE</button>
    <br><br>
    <a href="logout.php" class="btn btn-link">Logout</a>
</div>

</div>
</form>

<script>
document.querySelectorAll('.candidate-card').forEach(card => {
    card.addEventListener('click', function() {
        const radio = this.querySelector('.candidate-radio');
        const group = radio.name;

        // Remove selected from group
        document.querySelectorAll(`input[name="${group}"]`).forEach(r => {
            r.closest('.candidate-card').classList.remove('selected');
        });

        // Select this one
        radio.checked = true;
        this.classList.add('selected');
    });
});
</script>

<?php require_once '../includes/footer.php'; ?>
