<?php
require_once '../includes/header.php';
check_voter_login(); // ensure voter is logged in

$voter_id = $_SESSION['voter_id'];
$summary_votes = [];
$error = "";

// Fetch voting status
$sql_vstatus = "SELECT has_voted FROM voters WHERE id = ?";
if ($stmt = $conn->prepare($sql_vstatus)) {
    $stmt->bind_param("i", $voter_id);
    $stmt->execute();
    $stmt->bind_result($has_voted);
    $stmt->fetch();
    $stmt->close();
}

// If they haven't voted, block access
if ($has_voted == 0) {
    echo "
        <div class='container mt-5'>
            <div class='alert alert-warning text-center'>
                You have not voted yet. Please cast your vote.
            </div>
            <div class='text-center'>
                <a href='vote.php' class='btn btn-primary btn-lg'>Go to Voting Page</a>
            </div>
        </div>
    ";
    require_once '../includes/footer.php';
    exit;
}

// Fetch the summary of their votes
$sql_summary = "
    SELECT 
        p.position_name, 
        c.candidate_name, 
        c.photo 
    FROM votes v
    JOIN positions p ON v.position_id = p.id
    JOIN candidates c ON v.candidate_id = c.id
    WHERE v.voter_id = ?
    ORDER BY p.id ASC
";

if ($stmt_sum = $conn->prepare($sql_summary)) {
    $stmt_sum->bind_param("i", $voter_id);
    $stmt_sum->execute();
    $result = $stmt_sum->get_result();
    while ($row = $result->fetch_assoc()) {
        $summary_votes[] = $row;
    }
    $stmt_sum->close();
}
?>

<div class="container mt-5">

    <h3 class="text-center mb-3">Your Vote Summary</h3>
    <p class="text-center text-muted mb-4">Below are the candidates you selected during voting.</p>

    <div class="row justify-content-center">

        <?php if (empty($summary_votes)): ?>
            <div class="col-12">
                <div class="alert alert-danger text-center">
                    No vote records found for your account.
                </div>
            </div>
        <?php else: ?>

            <?php foreach ($summary_votes as $vote): ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card shadow-sm">
                        <div class="card-body text-center">

                            <img src="../uploads/candidate_photos/<?php echo htmlspecialchars($vote['photo']); ?>"
                                class="img-fluid rounded-circle mb-3"
                                style="width: 120px; height: 120px; object-fit: cover;" />

                            <h5 class="card-title">
                                <?php echo htmlspecialchars($vote['candidate_name']); ?>
                            </h5>

                            <p class="text-muted mb-0">
                                <strong><?php echo htmlspecialchars($vote['position_name']); ?></strong>
                            </p>

                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

        <?php endif; ?>

    </div>

    <div class="text-center mt-4 mb-5">
        <a href="logout.php" class="btn btn-danger btn-lg">LOGOUT</a>
    </div>

</div>

<?php require_once '../includes/footer.php'; ?>
