<?php
// Vote Confirmation Page
require_once '../includes/header.php';
check_voter_login();

// Check if voter has actually voted (safety check)
$voter_id = $_SESSION['voter_id'];
$has_voted = 0;
$sql_check = "SELECT has_voted FROM voters WHERE id = ?";
if ($stmt_check = $conn->prepare($sql_check)) {
    $stmt_check->bind_param("i", $voter_id);
    $stmt_check->execute();
    $stmt_check->bind_result($has_voted);
    $stmt_check->fetch();
    $stmt_check->close();
}

// If they haven't voted, redirect them back to the voting page
if ($has_voted == 0) {
    header("location: vote.php");
    exit;
}

// The header.php already started the HTML structure for the public portal
?>

<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card text-center">
            <div class="card-body">
                <i class="mdi mdi-check-circle-outline mdi-48px text-success mb-3"></i>
                <h2 class="card-title text-success">Vote Successfully Cast!</h2>
                <p class="card-description">
                    Thank you, <strong><?php echo htmlspecialchars($_SESSION['voter_name']); ?></strong>, for participating in the TUC Voting process.
                </p>
                <p class="card-text">
                    Your vote has been securely recorded. You may now safely log out.
                </p>
                <a href="logout.php" class="btn btn-gradient-primary btn-lg mt-4">Logout</a>
            </div>
        </div>
    </div>
</div>

<?php
// Unset voter session variables after confirmation
unset($_SESSION['voter_id']);
unset($_SESSION['voter_name']);
unset($_SESSION['voter_staff_id']);

require_once '../includes/footer.php';
?>
