<?php
// Start session and include database
require_once 'db.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/* ---------------------------------------------
   LOGIN CHECKS (NO PARAMETERS NEEDED)
----------------------------------------------*/
function check_admin_login() {
    if (empty($_SESSION['admin_id'])) {
        header("Location: /tuc_voting/admin_login.php");
        exit;
    }
}

function check_voter_login() {
    if (empty($_SESSION['voter_id'])) {
        header("Location: /tuc_voting/public/voter_login.php");
        exit;
    }
}

/* ---------------------------------------------
   PROJECT ROOT + FIXED ASSET PATH
----------------------------------------------*/
$project_root = "/tuc_voting/";
$asset_prefix = $project_root . "assets/";

/* ---------------------------------------------
   DETECT WHETHER THIS IS AN ADMIN PAGE
----------------------------------------------*/
$current_page   = basename($_SERVER['PHP_SELF']);
$is_admin_page  = strpos($_SERVER['PHP_SELF'], "/admin/") !== false;
$calling_login  = ($current_page === "admin_login.php");

// Enforce login on ALL admin pages except login.php
if ($is_admin_page && !$calling_login) {
    check_admin_login();
}

/* ---------------------------------------------
   ADMIN HEADER
----------------------------------------------*/
if ($is_admin_page):
    $title = "TUC Voting Admin Dashboard";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?= $title ?></title>

    <!-- STYLES -->
    <link rel="stylesheet" href="<?= $asset_prefix ?>vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="<?= $asset_prefix ?>vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="<?= $asset_prefix ?>css/style.css">

    <link rel="shortcut icon" href="<?= $asset_prefix ?>images/favicon.png" />
</head>

<body>
<div class="container-scroller">

    <!-- TOP NAV -->
    <nav class="navbar default-layout-navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
        <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
            <a class="navbar-brand brand-logo" href="<?= $project_root ?>admin/index.php"><h3 class="m-0 fw-bold" style="color:#b66dff">TUC Voting</h3></a>
            <a class="navbar-brand brand-logo-mini" href="<?= $project_root ?>admin/index.php"><h3 class="m-0 fw-bold" style="color:#b66dff">TUC</h3></a>
        </div>

        <div class="navbar-menu-wrapper d-flex align-items-stretch">
            <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
                <span class="mdi mdi-menu"></span>
            </button>

            <ul class="navbar-nav navbar-nav-right">

                <li class="nav-item d-none d-lg-block full-screen-link">
                    <a class="nav-link">
                        <i class="mdi mdi-fullscreen" id="fullscreen-button"></i>
                    </a>
                </li>

                <li class="nav-item nav-logout d-none d-lg-block">
                    <a class="nav-link" href="logout.php">
                        <i class="mdi mdi-power"></i>
                    </a>
                </li>
                
            </ul>

            <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-bs-toggle="offcanvas">
                <span class="mdi mdi-menu"></span>
            </button>
        </div>
    </nav>


    <div class="container-fluid page-body-wrapper">

        <!-- SIDEBAR -->
        <nav class="sidebar sidebar-offcanvas" id="sidebar">
            <ul class="nav">

                <li class="nav-item nav-profile">
                    <a href="#" class="nav-link">
                        <div class="nav-profile-image">
                            <img src="<?= $asset_prefix ?>images/faces/face1.jpg" alt="profile">
                            <span class="login-status online"></span>
                        </div>
                        <div class="nav-profile-text d-flex flex-column">
                            <span class="font-weight-bold mb-2"><?= $_SESSION['admin_name'] ?? 'Admin User' ?></span>
                            <span class="text-secondary text-small"><?= $_SESSION['admin_role'] ?? 'Role' ?></span>
                        </div>
                        <i class="mdi mdi-bookmark-check text-success nav-profile-badge"></i>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?= $project_root ?>admin/index.php">
                        <span class="menu-title">Dashboard</span>
                        <i class="mdi mdi-home menu-icon"></i>
                    </a>
                </li>

                <!-- voters -->
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#voters-nav" aria-expanded="false" aria-controls="voters-nav">
                        <span class="menu-title">Manage Voters</span>
                        <i class="menu-arrow"></i>
                        <i class="mdi mdi-account-multiple menu-icon"></i>
                    </a>
                    <div class="collapse" id="voters-nav">
                        <ul class="nav flex-column sub-menu">
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/voters/add_voter.php">Add Voter</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/voters/view_voters.php">View Voters</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/voters/bulk_upload.php">Bulk Upload</a></li>
                        </ul>
                    </div>
                </li>

                <!-- election setup -->
                 <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#voters-nav2" aria-expanded="false" aria-controls="voters-nav2">
                        <span class="menu-title">Election Setup</span>
                        <i class="menu-arrow"></i>
                        <i class="mdi mdi-account-multiple menu-icon"></i>
                    </a>
                    <div class="collapse" id="voters-nav2">
                        <ul class="nav flex-column sub-menu">
                             <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/positions/index2.php">Positions</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/candidates/index3.php">Candidates</a></li>
                        </ul>
                    </div>
                </li>
                
                <!--
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#election-setup-nav" aria-expanded="false" aria-controls="election-setup-nav">
                        <span class="menu-title">Election Setup</span>
                        <i class="menu-arrow"></i>
                        <i class="mdi mdi-settings menu-icon"></i>
                    </a>
                    <div class="collapse" id="election-setup-nav">
                        <ul class="nav flex-column sub-menu">
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/positions/index.php">Positions</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/candidates/index.php">Candidates</a></li>
                        </ul>
                    </div>
                </li>
                -->

                <!-- voters activity -->
                <li class="nav-item">
                    <a class="nav-link" href="<?= $project_root ?>admin/voters/activity_log.php">
                        <span class="menu-title">Voters Activity</span>
                        <i class="mdi mdi-format-list-bulleted menu-icon"></i>
                    </a>
                </li>

                <!-- results -->
                <li class="nav-item">
                    <a class="nav-link" href="<?= $project_root ?>admin/results/index4.php">
                        <span class="menu-title">Election Results</span>
                        <i class="mdi mdi-chart-bar menu-icon"></i>
                    </a>
                </li>

                <!-- super admin -->
                <?php if (!empty($_SESSION['admin_role']) && $_SESSION['admin_role'] === 'super_admin'): ?>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#users-nav">
                        <span class="menu-title">Manage Users</span>
                        <i class="menu-arrow"></i>
                        <i class="mdi mdi-account-key menu-icon"></i>
                    </a>
                    <div class="collapse" id="users-nav">
                        <ul class="nav flex-column sub-menu">
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/users/add_user.php">Add User</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?= $project_root ?>admin/users/view_users.php">View Users</a></li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>

            </ul>
        </nav>

        <div class="main-panel">
            <div class="content-wrapper">
<?php
/* ---------------------------------------------
   PUBLIC HEADER
----------------------------------------------*/
else:
    $title = "TUC Voting Portal";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?= $title ?></title>

    <link rel="stylesheet" href="<?= $asset_prefix ?>vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="<?= $asset_prefix ?>vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="<?= $asset_prefix ?>css/style.css">
    <link rel="shortcut icon" href="<?= $asset_prefix ?>images/favicon.png" />
</head>

<body>
<div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
        <div class="content-wrapper d-flex align-items-center auth">
            <div class="row flex-grow">
                <div class="col-lg-6 mx-auto">
                    <div class="auth-form-light text-left p-5">
                        <div class="brand-logo text-center">
                            <h1>TUC Voting</h1>
                        </div>
<?php endif; ?>
