<?php
// Include database connection and session start
require_once 'db.php';

// Determine the base path for assets
$script_dir = dirname($_SERVER['PHP_SELF']);
$relative_path = '';

// Calculate the relative path to the project root
$path_parts = explode('/', trim($script_dir, '/'));
$depth = 0;
foreach ($path_parts as $part) {
    if ($part === 'admin' || $part === 'public' || $part === 'voters' || $part === 'positions' || $part === 'candidates' || $part === 'users' || $part === 'results') {
        $depth++;
    }
}

$asset_prefix = str_repeat('../', $depth) . 'assets/';

// Check if this is an admin page to apply the full template
$is_admin_page = (strpos($_SERVER['PHP_SELF'], '/admin/') !== false || strpos($_SERVER['PHP_SELF'], '/admin_login.php') !== false);

if ($is_admin_page) {
    // Admin-specific footer content
?>
                </div>
                <!-- content-wrapper ends -->
                <!-- partial:partials/_footer.html -->
                <footer class="footer">
                    <div class="d-sm-flex justify-content-center justify-content-sm-between">
                        <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2024 TUC Voting. All rights reserved.</span>
                        <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Free <a href="https://www.bootstrapdash.com/bootstrap-admin-template/" target="_blank">Bootstrap admin templates</a> from Bootstrapdash.com</span>
                    </div>
                </footer>
                <!-- partial -->
            </div>
            <!-- main-panel ends -->
        </div>
        <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->
    <!-- plugins:js -->
    <script src="<?php echo $asset_prefix; ?>vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="<?php echo $asset_prefix; ?>vendors/chart.js/Chart.min.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="<?php echo $asset_prefix; ?>js/off-canvas.js"></script>
    <script src="<?php echo $asset_prefix; ?>js/hoverable-collapse.js"></script>
    <script src="<?php echo $asset_prefix; ?>js/misc.js"></script>
    <!-- endinject -->
    <!-- Custom js for this page -->
    <!-- Removed dashboard.js and todolist.js to prevent conflicts/loops -->
     
</body>
</html>
<?php
} else {
    // Public-specific footer content (for login/voting pages)
    // $asset_prefix is already calculated above
?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- content-wrapper ends -->
        </div>
        <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->
    <!-- plugins:js -->
    <script src="<?php echo $asset_prefix; ?>vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- inject:js -->
    <script src="<?php echo $asset_prefix; ?>js/off-canvas.js"></script>
    <script src="<?php echo $asset_prefix; ?>js/hoverable-collapse.js"></script>
    <script src="<?php echo $asset_prefix; ?>js/misc.js"></script>
    <!-- endinject -->
</body>
</html>
<?php
}
// Close the database connection (optional, but good practice)
close_db_connection($conn);
?>
