<?php
/**
 * Mock Email Utility (email_mock.php)
 * This file simulates sending an email with voter login details.
 * In a production environment, this would be replaced with a real email library (e.g., PHPMailer).
 */

function send_voter_credentials_email($staff_id, $password, $full_name) {
    // In a real application, you would use PHPMailer or a similar library here.
    // Since the environment does not support external SMTP services, we will log the email content.

    $subject = "Your TUC Voting Credentials";
    $body = "
        Dear {$full_name},

        Your account for the TUC Voting System has been created.

        Please use the following credentials to log in and cast your vote:

        **Staff ID (Username):** {$staff_id}
        **Password:** {$password}

        Please keep your password secure.

        Thank you,
        TUC Election Administrator
    ";

    // Mock logging the email content to a file
    $log_message = "--- MOCK EMAIL SENT ---\n";
    $log_message .= "To: {$full_name} (Staff ID: {$staff_id})\n";
    $log_message .= "Subject: {$subject}\n";
    $log_message .= "Body:\n{$body}\n";
    $log_message .= "-----------------------\n\n";

    // Log to a file in the uploads directory
    file_put_contents(__DIR__ . '/../uploads/email_log.txt', $log_message, FILE_APPEND);

    return true; // Assume success for the mock
}

?>
