<?php
// Add Single Voter
require_once '../../includes/header.php';
require_once '../../includes/email_mock.php';
check_admin_login();

$message = '';

// Voters now have unique passwords.
function generate_random_password($length = 10) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()';
    $password = '';
    for ($i = 0; $i < $length; $i++) {
        $password .= $chars[rand(0, strlen($chars) - 1)];
    }
    return $password;
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_voter'])) {
    $staff_id = trim($_POST['staff_id']);
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $department = trim($_POST['department']);

    if (empty($staff_id) || empty($full_name) || empty($email) || empty($department)) {
        $message = '<div class="alert alert-danger">All fields are required.</div>';
    } else {
        $sql = "INSERT INTO voters (staff_id, full_name, email, department, password) VALUES (?, ?, ?, ?, ?)";
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("sssss", $param_staff_id, $param_full_name, $param_email, $param_department, $param_password);
            // Generate unique password and hash it
            $raw_password = generate_random_password(10);
            $hashed_password = password_hash($raw_password, PASSWORD_BCRYPT);

            $param_staff_id = $staff_id;
            $param_full_name = $full_name;
            $param_email = $email;
            $param_department = $department;
            $param_password = $hashed_password;

            if ($stmt->execute()) {
                // Send email with credentials
                send_voter_credentials_email($staff_id, $raw_password, $full_name);
                
                $email_message = "Voter added successfully. Staff ID: <strong>" . htmlspecialchars($staff_id) . "</strong>. A unique password has been generated and a mock email has been logged. (Check uploads/email_log.txt)";
                $message = '<div class="alert alert-success">' . $email_message . '</div>';
            } else {
                if ($conn->errno == 1062) { // Duplicate entry error code
                    $message = '<div class="alert alert-danger">Error: Staff ID <strong>' . htmlspecialchars($staff_id) . '</strong> already exists.</div>';
                } else {
                    $message = '<div class="alert alert-danger">Error: Could not add voter. ' . $conn->error . '</div>';
                }
            }
            $stmt->close();
        }
    }
}
?>

<div class="page-header">
    <h3 class="page-title">
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
            <i class="mdi mdi-account-plus"></i>
        </span> Add Single Voter
    </h3>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="../index.php">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="view_voters.php">Manage Voters</a></li>
            <li class="breadcrumb-item active" aria-current="page">Add Voter</li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-md-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Voter Details</h4>
                <p class="card-description">
                    Enter the details for a new voter.
                </p>
                <?php echo $message; ?>
                <form class="forms-sample" method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                    <div class="form-group">
                        <label for="staff_id">Staff ID (Username)</label>
                        <input type="text" class="form-control" id="staff_id" name="staff_id" placeholder="e.g., TUC12345" required>
                    </div>
                    <div class="form-group">
                        <label for="full_name">Full Name</label>
                        <input type="text" class="form-control" id="full_name" name="full_name" placeholder="Full Name" required>
                    </div>

                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="text" class="form-control" id="email" name="email" placeholder="Email" required>
                    </div>
                    <div class="form-group">
                        <label for="department">Department</label>
                        <input type="text" class="form-control" id="department" name="department" placeholder="Department Name" required>
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input type="text" class="form-control" value="A unique password will be generated and emailed." disabled>
                        <small class="form-text text-muted">A unique password will be generated for this voter upon creation.</small>
                    </div>
                    <button type="submit" name="add_voter" class="btn btn-gradient-primary mr-2">Add Voter</button>
                    <button type="reset" class="btn btn-light">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../../includes/footer.php';
?>
