<?php
// Voters Activity Log
require_once '../../includes/header.php';
check_admin_login();

// --- Fetch Voters Activity Data ---
$voters_activity = [];
$sql_fetch = "SELECT id, staff_id, full_name, department, has_voted, created_at FROM voters ORDER BY has_voted ASC, full_name ASC";
if ($result = $conn->query($sql_fetch)) {
    while ($row = $result->fetch_assoc()) {
        $voters_activity[] = $row;
    }
    $result->free();
}

// --- Fetch Vote Timestamps (for those who voted) ---
$vote_timestamps = [];
$sql_timestamps = "SELECT voter_id, MIN(created_at) as first_vote_time FROM votes GROUP BY voter_id";
if ($result = $conn->query($sql_timestamps)) {
    while ($row = $result->fetch_assoc()) {
        $vote_timestamps[$row['voter_id']] = $row['first_vote_time'];
    }
    $result->free();
}

?>

<div class="page-header">
    <h3 class="page-title">
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
            <i class="mdi mdi-format-list-bulleted"></i>
        </span> Voters Activity Log
    </h3>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="../index.php">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Activity Log</li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Voter Status and Activity</h4>
                <p class="card-description">
                    Monitor which voters have cast their vote and the time of their first vote.
                </p>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Staff ID</th>
                                <th>Full Name</th>
                                <th>Department</th>
                                <th>Status</th>
                                <th>Vote Timestamp</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($voters_activity) > 0): ?>
                                <?php foreach ($voters_activity as $voter): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($voter['staff_id']); ?></td>
                                        <td><?php echo htmlspecialchars($voter['full_name']); ?></td>
                                        <td><?php echo htmlspecialchars($voter['department']); ?></td>
                                        <td>
                                            <label class="badge badge-<?php echo $voter['has_voted'] ? 'success' : 'danger'; ?>">
                                                <?php echo $voter['has_voted'] ? 'Voted' : 'Not Voted'; ?>
                                            </label>
                                        </td>
                                        <td>
                                            <?php
                                            if ($voter['has_voted'] && isset($vote_timestamps[$voter['id']])) {
                                                echo date('Y-m-d H:i:s', strtotime($vote_timestamps[$voter['id']]));
                                            } else {
                                                echo 'N/A';
                                            }
                                            ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5" class="text-center">No voters registered.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../../includes/footer.php';
?>
