<?php
// Add Admin User
require_once '../../includes/header.php';
check_admin_login();

// Restrict access to only super_admin
if ($_SESSION['admin_role'] !== 'super_admin') {
    header("location: ../index.php");
    exit;
}

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_user'])) {
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $role = $_POST['role'];

    if (empty($full_name) || empty($email) || empty($password) || empty($role)) {
        $message = '<div class="alert alert-danger">All fields are required.</div>';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = '<div class="alert alert-danger">Invalid email format.</div>';
    } elseif (!in_array($role, ['super_admin', 'normal_admin'])) {
        $message = '<div class="alert alert-danger">Invalid role selected.</div>';
    } else {
        // Hash the password
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        $sql = "INSERT INTO users (full_name, email, password, role) VALUES (?, ?, ?, ?)";
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("ssss", $param_full_name, $param_email, $param_password, $param_role);
            $param_full_name = $full_name;
            $param_email = $email;
            $param_password = $hashed_password;
            $param_role = $role;

            if ($stmt->execute()) {
                $message = '<div class="alert alert-success">Admin user <strong>' . htmlspecialchars($full_name) . '</strong> added successfully.</div>';
            } else {
                if ($conn->errno == 1062) { // Duplicate entry error code
                    $message = '<div class="alert alert-danger">Error: Email <strong>' . htmlspecialchars($email) . '</strong> already exists.</div>';
                } else {
                    $message = '<div class="alert alert-danger">Error: Could not add user. ' . $conn->error . '</div>';
                }
            }
            $stmt->close();
        }
    }
}
?>

<div class="page-header">
    <h3 class="page-title">
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
            <i class="mdi mdi-account-key"></i>
        </span> Add Admin User
    </h3>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="../index.php">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="view_users.php">Manage Users</a></li>
            <li class="breadcrumb-item active" aria-current="page">Add User</li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-md-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">New Admin User Details</h4>
                <?php echo $message; ?>
                <form class="forms-sample" method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                    <div class="form-group">
                        <label for="full_name">Full Name</label>
                        <input type="text" class="form-control" id="full_name" name="full_name" placeholder="Full Name" required>
                    </div>
                    <div class="form-group">
                        <label for="email">Email (Username)</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Email Address" required>
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                    </div>
                    <div class="form-group">
                        <label for="role">Role</label>
                        <select class="form-control" id="role" name="role" required>
                            <option value="normal_admin">Normal Admin</option>
                            <option value="super_admin">Super Admin</option>
                        </select>
                    </div>
                    <button type="submit" name="add_user" class="btn btn-gradient-primary mr-2">Add User</button>
                    <button type="reset" class="btn btn-light">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../../includes/footer.php';
?>
