<?php
// Positions Management
require_once '../../includes/header.php';
check_admin_login();

$message = '';

// --- CRUD Operations ---

// 1. Add Position
if (isset($_POST['add_position'])) {
    $position_name = trim($_POST['position_name']);
    if (!empty($position_name)) {
        $sql = "INSERT INTO positions (position_name) VALUES (?)";
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("s", $param_name);
            $param_name = $position_name;
            if ($stmt->execute()) {
                $message = '<div class="alert alert-success">Position added successfully.</div>';
            } else {
                $message = '<div class="alert alert-danger">Error: Could not add position. ' . $conn->error . '</div>';
            }
            $stmt->close();
        }
    } else {
        $message = '<div class="alert alert-warning">Position name cannot be empty.</div>';
    }
}

// 2. Edit Position
if (isset($_POST['edit_position'])) {
    $id = $_POST['position_id'];
    $position_name = trim($_POST['position_name']);
    if (!empty($position_name) && is_numeric($id)) {
        $sql = "UPDATE positions SET position_name = ? WHERE id = ?";
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("si", $param_name, $param_id);
            $param_name = $position_name;
            $param_id = $id;
            if ($stmt->execute()) {
                $message = '<div class="alert alert-success">Position updated successfully.</div>';
            } else {
                $message = '<div class="alert alert-danger">Error: Could not update position. ' . $conn->error . '</div>';
            }
            $stmt->close();
        }
    } else {
        $message = '<div class="alert alert-warning">Invalid data provided for update.</div>';
    }
}

// 3. Delete Position
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id = $_GET['id'];
    if (is_numeric($id)) {
        $sql = "DELETE FROM positions WHERE id = ?";
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("i", $param_id);
            $param_id = $id;
            if ($stmt->execute()) {
                $message = '<div class="alert alert-success">Position deleted successfully.</div>';
            } else {
                $message = '<div class="alert alert-danger">Error: Could not delete position. ' . $conn->error . '</div>';
            }
            $stmt->close();
        }
    }
}

// --- Fetch Positions ---
$positions = [];
$sql_fetch = "SELECT id, position_name FROM positions ORDER BY position_name ASC";
if ($result = $conn->query($sql_fetch)) {
    while ($row = $result->fetch_assoc()) {
        $positions[] = $row;
    }
    $result->free();
}

?>

<div class="page-header">
    <h3 class="page-title">
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
            <i class="mdi mdi-sitemap"></i>
        </span> Manage Positions
    </h3>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="../index.php">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Positions</li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Election Positions</h4>
                <p class="card-description">
                    List of all political positions for the election.
                </p>
                <?php echo $message; ?>
                <button type="button" class="btn btn-gradient-primary btn-sm mb-3" data-toggle="modal" data-target="#addPositionModal">
                    Add New Position
                </button>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Position Name</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($positions) > 0): ?>
                                <?php foreach ($positions as $position): ?>
                                    <tr>
                                        <td><?php echo $position['id']; ?></td>
                                        <td><?php echo htmlspecialchars($position['position_name']); ?></td>
                                        <td>
                                            <button type="button" class="btn btn-info btn-sm btn-icon-text edit-btn"
                                                    data-id="<?php echo $position['id']; ?>"
                                                    data-name="<?php echo htmlspecialchars($position['position_name']); ?>"
                                                    data-toggle="modal" data-target="#editPositionModal">
                                                Edit <i class="mdi mdi-pencil btn-icon-append"></i>
                                            </button>
                                            <a href="?action=delete&id=<?php echo $position['id']; ?>"
                                               onclick="return confirm('Are you sure you want to delete this position? All associated candidates and votes will also be deleted.')"
                                               class="btn btn-danger btn-sm btn-icon-text">
                                                Delete <i class="mdi mdi-delete btn-icon-append"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="3" class="text-center">No positions found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Position Modal -->
<div class="modal fade" id="addPositionModal" tabindex="-1" role="dialog" aria-labelledby="addPositionModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPositionModalLabel">Add New Position</h5>
                <!-- <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button> -->

                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="position_name">Position Name</label>
                        <input type="text" class="form-control" id="position_name" name="position_name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" name="add_position" class="btn btn-primary">Save Position</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Position Modal -->
<div class="modal fade" id="editPositionModal" tabindex="-1" role="dialog" aria-labelledby="editPositionModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPositionModalLabel">Edit Position</h5>
                <!-- <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button> -->
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                <div class="modal-body">
                    <input type="hidden" id="edit_position_id" name="position_id">
                    <div class="form-group">
                        <label for="edit_position_name">Position Name</label>
                        <input type="text" class="form-control" id="edit_position_name" name="position_name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" name="edit_position" class="btn btn-primary">Update Position</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // JavaScript to populate the Edit Modal fields
    window.onload = function() {
        // var editModal = document.getElementById('editPositionModal');
        // if (editModal) {
        //     editModal.addEventListener('show.bs.modal', function (event) {
        //         var button = event.relatedTarget; // Button that triggered the modal
        //         var id = button.getAttribute('data-id');
        //         var name = button.getAttribute('data-name');

        //         var modalIdInput = editModal.querySelector('#edit_position_id');
        //         var modalNameInput = editModal.querySelector('#edit_position_name');

        //         modalIdInput.value = id;
        //         modalNameInput.value = name;
        //     });
        // }
         $(document).on('click', '[data-target="#addPositionModal"]', function () {

        // Clear the input field before opening
        $('#position_name').val('');

        // Open the modal
        $('#addPositionModal').modal('show');
    });


    // ---------------------------
    // OPEN EDIT POSITION MODAL
    // ---------------------------
    $(document).on('click', '.edit-btn', function () {

        // Get values from the Edit button
        var id = $(this).data('id');
        var name = $(this).data('name');

        // Fill modal fields
        $('#edit_position_id').val(id);
        $('#edit_position_name').val(name);

        // Open the modal
        $('#editPositionModal').modal('show');
    });


    };
</script>

<?php
require_once '../../includes/footer.php';
?>


