<?php
// Admin Dashboard
require_once '../includes/header.php';

// check_admin_login() is called in header.php

// Fetch Dashboard Data
$total_voters = 0;
$voted_count = 0;
$total_positions = 0;
$total_candidates = 0;

// 1. Total Voters
$sql_voters = "SELECT COUNT(*) FROM voters";
if ($stmt = $conn->prepare($sql_voters)) {
    $stmt->execute();
    $stmt->bind_result($total_voters);
    $stmt->fetch();
    $stmt->close();
}

// 2. Voted Count
$sql_voted = "SELECT COUNT(*) FROM voters WHERE has_voted = 1";
if ($stmt = $conn->prepare($sql_voted)) {
    $stmt->execute();
    $stmt->bind_result($voted_count);
    $stmt->fetch();
    $stmt->close();
}

// 3. Total Positions
$sql_positions = "SELECT COUNT(*) FROM positions";
if ($stmt = $conn->prepare($sql_positions)) {
    $stmt->execute();
    $stmt->bind_result($total_positions);
    $stmt->fetch();
    $stmt->close();
}

// 4. Total Candidates
$sql_candidates = "SELECT COUNT(*) FROM candidates";
if ($stmt = $conn->prepare($sql_candidates)) {
    $stmt->execute();
    $stmt->bind_result($total_candidates);
    $stmt->fetch();
    $stmt->close();
}

$not_voted_count = $total_voters - $voted_count;
$voted_percentage = $total_voters > 0 ? round(($voted_count / $total_voters) * 100, 2) : 0;

?>

<div class="page-header">
    <h3 class="page-title">
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
            <i class="mdi mdi-home"></i>
        </span> Dashboard
    </h3>
    <nav aria-label="breadcrumb">
        <ul class="breadcrumb">
            <li class="breadcrumb-item active" aria-current="page">
                <span></span>Overview <i class="mdi mdi-alert-circle-outline icon-sm text-primary align-middle"></i>
            </li>
        </ul>
    </nav>
</div>
<div class="row">
    <div class="col-md-3 stretch-card grid-margin">
        <div class="card bg-gradient-danger card-img-holder text-white">
            <div class="card-body">
                <img src="../assets/images/dashboard/circle.svg" class="card-img-absolute" alt="circle-image" />
                <h4 class="font-weight-normal mb-3">Total Voters <i class="mdi mdi-account-multiple mdi-24px float-right"></i>
                </h4>
                <h2 class="mb-5"><?php echo $total_voters; ?></h2>
                <h6 class="card-text">Registered Staff</h6>
            </div>
        </div>
    </div>
    <div class="col-md-3 stretch-card grid-margin">
        <div class="card bg-gradient-info card-img-holder text-white">
            <div class="card-body">
                <img src="../assets/images/dashboard/circle.svg" class="card-img-absolute" alt="circle-image" />
                <h4 class="font-weight-normal mb-3">Voters Cast <i class="mdi mdi-check-circle mdi-24px float-right"></i>
                </h4>
                <h2 class="mb-5"><?php echo $voted_count; ?></h2>
                <h6 class="card-text"><?php echo $voted_percentage; ?>% of Total Voters</h6>
            </div>
        </div>
    </div>
    <div class="col-md-3 stretch-card grid-margin">
        <div class="card bg-gradient-success card-img-holder text-white">
            <div class="card-body">
                <img src="../assets/images/dashboard/circle.svg" class="card-img-absolute" alt="circle-image" />
                <h4 class="font-weight-normal mb-3">Total Positions <i class="mdi mdi-sitemap mdi-24px float-right"></i>
                </h4>
                <h2 class="mb-5"><?php echo $total_positions; ?></h2>
                <h6 class="card-text">Election Roles</h6>
            </div>
        </div>
    </div>
    <div class="col-md-3 stretch-card grid-margin">
        <div class="card bg-gradient-warning card-img-holder text-white">
            <div class="card-body">
                <img src="../assets/images/dashboard/circle.svg" class="card-img-absolute" alt="circle-image" />
                <h4 class="font-weight-normal mb-3">Total Candidates <i class="mdi mdi-account-star mdi-24px float-right"></i>
                </h4>
                <h2 class="mb-5"><?php echo $total_candidates; ?></h2>
                <h6 class="card-text">Running for Office</h6>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-7 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Voting Progress</h4>
                <canvas id="voting-progress-chart" style="height:250px"></canvas>
            </div>
        </div>
    </div>
    <div class="col-lg-5 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Top 5 Positions by Votes</h4>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Position</th>
                                <th>Total Votes</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // Fetch top 5 positions by total votes
                            $sql_top_positions = "SELECT p.position_name, COUNT(v.id) AS total_votes
                                                  FROM votes v
                                                  JOIN positions p ON v.position_id = p.id
                                                  GROUP BY p.id
                                                  ORDER BY total_votes DESC
                                                  LIMIT 5";
                            if ($result = $conn->query($sql_top_positions)) {
                                if ($result->num_rows > 0) {
                                    while ($row = $result->fetch_assoc()) {
                                        echo '<tr>';
                                        echo '<td>' . htmlspecialchars($row['position_name']) . '</td>';
                                        echo '<td>' . $row['total_votes'] . '</td>';
                                        echo '</tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="2">No votes cast yet.</td></tr>';
                                }
                                $result->free();
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Data for the Voting Progress Chart
        var votedCount = <?php echo $voted_count; ?>;
        var notVotedCount = <?php echo $not_voted_count; ?>;

        var data = {
            labels: ['Voted', 'Not Voted'],
            datasets: [{
                data: [votedCount, notVotedCount],
                backgroundColor: ['#57b657', '#ff4747'], // Success and Danger colors
                hoverBackgroundColor: ['#4ca04c', '#e63e3e']
            }]
        };

        var options = {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'top',
            },
            title: {
                display: false,
                text: 'Voting Progress'
            },
            animation: {
                animateScale: true,
                animateRotate: true
            }
        };

        // var ctx = document.getElementById('voting-progress-chart').getContext('2d');
        // new Chart(ctx, {
        //     type: 'pie',
        //     data: data,
        //     options: options
        // });
    });
</script>

<?php
require_once '../includes/footer.php';
?>
