<?php
// Candidates Management
require_once '../../includes/header.php';
check_admin_login();

$message = '';
$upload_dir = '../../uploads/candidate_photos/';

// ---------------- FETCH POSITIONS ----------------
$positions_list = [];
$res = $conn->query("SELECT id, position_name FROM positions ORDER BY position_name ASC");
while ($row = $res->fetch_assoc()) $positions_list[] = $row;


// -------------------------------------------------------------
// 1. ADD CANDIDATE
// -------------------------------------------------------------
if (isset($_POST['add_candidate'])) {

    $candidate_name = trim($_POST['candidate_name']);
    $position_id = intval($_POST['position_id']);
    $photo = "default.png";

    if ($candidate_name !== "" && $position_id > 0) {

        // Upload photo if present
        if (!empty($_FILES['photo']['name'])) {
            $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));
            if (in_array($ext, ['jpg','jpeg','png'])) {
                $photo = uniqid('cand_') . "." . $ext;
                move_uploaded_file($_FILES['photo']['tmp_name'], $upload_dir . $photo);
            }
        }

        $stmt = $conn->prepare("INSERT INTO candidates (position_id, candidate_name, photo) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $position_id, $candidate_name, $photo);
        $stmt->execute();

        $message = '<div class="alert alert-success">Candidate added successfully.</div>';
    } 
}



// -------------------------------------------------------------
// 2. DELETE CANDIDATE
// -------------------------------------------------------------
if (isset($_GET['action'], $_GET['id']) && $_GET['action'] === "delete") {

    $id = intval($_GET['id']);

    // Get photo name
    $res = $conn->query("SELECT photo FROM candidates WHERE id=$id");
    $row = $res->fetch_assoc();
    $photo = $row['photo'];

    // Delete from DB
    $conn->query("DELETE FROM candidates WHERE id=$id");

    // Delete old photo
    if ($photo !== "default.png" && file_exists($upload_dir . $photo)) {
        unlink($upload_dir . $photo);
    }

    $message = '<div class="alert alert-success">Candidate deleted successfully.</div>';
}



// -------------------------------------------------------------
// 3. UPDATE CANDIDATE (Name, Position, Photo)
// -------------------------------------------------------------
if (isset($_POST['edit_candidate'])) {

    $id = intval($_POST['candidate_id']);
    $name = trim($_POST['candidate_name']);
    $position_id = intval($_POST['position_id_edit']);

    // Fetch old photo
    $old = $conn->query("SELECT photo FROM candidates WHERE id=$id")->fetch_assoc();
    $old_photo = $old['photo'];
    $new_photo = $old_photo;

    // If new file uploaded
    if (!empty($_FILES['edit_photo']['name'])) {

        $ext = strtolower(pathinfo($_FILES['edit_photo']['name'], PATHINFO_EXTENSION));

        if (in_array($ext, ['jpg','jpeg','png'])) {

            $new_photo = uniqid('cand_') . "." . $ext;

            move_uploaded_file($_FILES['edit_photo']['tmp_name'], $upload_dir . $new_photo);

            // delete old photo (if not default)
            if ($old_photo !== "default.png" && file_exists($upload_dir . $old_photo)) {
                unlink($upload_dir . $old_photo);
            }
        }
    }

    // Update DB
    $stmt = $conn->prepare("UPDATE candidates SET candidate_name=?, position_id=?, photo=? WHERE id=?");
    $stmt->bind_param("sisi", $name, $position_id, $new_photo, $id);
    $stmt->execute();

    $message = '<div class="alert alert-success">Candidate updated successfully.</div>';
}



// -------------------------------------------------------------
// FETCH ALL CANDIDATES
// -------------------------------------------------------------
$candidates = [];
$sql = "SELECT c.id, c.candidate_name, c.photo, p.position_name, p.id AS pos_id
        FROM candidates c
        JOIN positions p ON c.position_id = p.id
        ORDER BY p.position_name, c.candidate_name ASC";
$res = $conn->query($sql);
while ($row = $res->fetch_assoc()) $candidates[] = $row;

?>

<div class="page-header">
    <h3 class="page-title">
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
            <i class="mdi mdi-account-star"></i>
        </span> Manage Candidates
    </h3>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="../index.php">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Candidates</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <h4 class="card-title">Election Candidates</h4>
        <p class="card-description">
            List of all political candidates for the election.
        </p>

        <?= $message ?>
        <button type="button" class="btn btn-gradient-primary btn-sm mb-3"
                data-bs-toggle="modal" data-bs-target="#addCandidateModal">
            Add New Candidate
        </button>

        <div class="table-responsive">
            <table class="table table-hover">

                <thead>
                <tr>
                    <th>ID</th>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Position</th>
                    <th>Actions</th>
                </tr>
                </thead>

                <tbody>
                <?php foreach ($candidates as $c): ?>
                    <tr>
                        <td><?= $c['id'] ?></td>

                        <td>
                            <img src="<?= '../../uploads/candidate_photos/' . $c['photo'] ?>"
                                 style="width:45px;height:45px;border-radius:50%;object-fit:cover;">
                        </td>

                        <td><?= htmlspecialchars($c['candidate_name']) ?></td>

                        <td><?= htmlspecialchars($c['position_name']) ?></td>

                        <td>
                            <button class="btn btn-info btn-sm edit-btn"
                                data-id="<?= $c['id'] ?>"
                                data-name="<?= htmlspecialchars($c['candidate_name']) ?>"
                                data-position="<?= $c['pos_id'] ?>"
                                data-photo="<?= $c['photo'] ?>"
                                data-bs-toggle="modal"
                                data-bs-target="#editCandidateModal">
                                Edit <i class="mdi mdi-pencil btn-icon-append"></i>
                            </button>

                            <a href="?action=delete&id=<?= $c['id'] ?>"
                               onclick="return confirm('Delete this candidate?')"
                               class="btn btn-danger btn-sm">
                                Delete <i class="mdi mdi-delete btn-icon-append"></i>
                            </a>
                        </td>

                    </tr>
                <?php endforeach; ?>
                </tbody>

            </table>
        </div>
    </div>
</div>


<!-- ===================== ADD MODAL ======================== -->
<div class="modal fade" id="addCandidateModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" enctype="multipart/form-data" class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Add Candidate</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <div class="form-group mb-2">
                    <label>Name</label>
                    <input type="text" name="candidate_name" class="form-control" required>
                </div>

                <div class="form-group mb-2">
                    <label>Position</label>
                    <select name="position_id" class="form-control" required>
                        <option value="">-- Select Position --</option>
                        <?php foreach ($positions_list as $p): ?>
                            <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['position_name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group mb-2">
                    <label>Photo</label>
                    <input type="file" name="photo" class="form-control" accept=".jpg,.jpeg,.png">
                </div>

            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" name="add_candidate" class="btn btn-primary">Save</button>
            </div>

        </form>
    </div>
</div>


<!-- ===================== EDIT MODAL ======================== -->
<div class="modal fade" id="editCandidateModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" enctype="multipart/form-data" class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Edit Candidate</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <input type="hidden" id="edit_candidate_id" name="candidate_id">

                <div class="form-group mb-2">
                    <label>Name</label>
                    <input type="text" id="edit_candidate_name" name="candidate_name" class="form-control" required>
                </div>

                <div class="form-group mb-2">
                    <label>Position</label>
                    <select id="edit_position_id" name="position_id_edit" class="form-control" required>
                        <?php foreach ($positions_list as $p): ?>
                            <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['position_name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group mb-2">
                    <label>Change Photo (optional)</label>
                    <input type="file" name="edit_photo" class="form-control">
                </div>

                <div class="mt-2">
                    <label>Current Photo:</label><br>
                    <img id="edit_preview_photo"
                         src=""
                         style="width:70px;height:70px;border-radius:50%;object-fit:cover;">
                </div>

            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" name="edit_candidate" class="btn btn-primary">Update</button>
            </div>

        </form>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>


<script>
// Populate EDIT modal when clicking edit button
document.addEventListener("click", function (e) {
    if (e.target.closest(".edit-btn")) {

        let btn = e.target.closest(".edit-btn");

        document.getElementById("edit_candidate_id").value = btn.dataset.id;
        document.getElementById("edit_candidate_name").value = btn.dataset.name;

        document.getElementById("edit_position_id").value = btn.dataset.position;

        document.getElementById("edit_preview_photo").src =
            "../../uploads/candidate_photos/" + btn.dataset.photo;
    }
});
</script>
