# TUC Voting System

## Project Overview

The TUC Voting System is a complete, product-ready web application built using **Pure PHP (no frameworks)** and **MySQL** for a secure and simple staff voting process. It features two distinct portals: an **Admin Portal** for election management and a **Public Portal** for voter login and casting votes. The entire system is styled using the **Purple Free Admin Template** for a modern, responsive user interface.

## Prerequisites

To run this application, you will need a web server environment with the following components:

*   **Web Server:** Apache, Nginx, or equivalent (with PHP support).
*   **PHP:** Version 7.4 or higher (PHP 8.1+ is recommended).
    *   Required extensions: `php-mysqli`, `php-bcmath` (for password hashing).
*   **Database:** MySQL or MariaDB.

## Setup Instructions

### 1. Folder Structure

The project follows the required structure. The `tuc_voting` directory contains all the necessary files.

```
tuc_voting/
├── admin/
│   ├── candidates/
│   │   └── index.php (Manage Candidates)
│   ├── positions/
│   │   └── index.php (Manage Positions)
│   ├── users/
│   │   ├── add_user.php (Add Admin)
│   │   └── view_users.php (Manage Admins)
│   ├── voters/
│   │   ├── activity_log.php (Voters Activity)
│   │   ├── add_voter.php (Add Single Voter)
│   │   ├── bulk_upload.php (Bulk CSV Upload)
│   │   └── view_voters.php (Manage Voters)
│   ├── index.php (Admin Dashboard)
│   └── logout.php (Admin Logout)
├── assets/ (Purple Template Assets: CSS, JS, Fonts, Images)
├── includes/
│   ├── db.php (Database Connection & Session)
│   ├── footer.php (Admin/Public Footer Template)
│   └── header.php (Admin/Public Header Template)
├── public/
│   ├── confirmation.php (Vote Receipt)
│   ├── logout.php (Voter Logout)
│   ├── voter_login.php (Voter Login Page)
│   └── vote.php (Main Voting Page)
├── uploads/
│   └── candidate_photos/ (Candidate Photo Storage)
├── admin_login.php (Admin Login Page)
├── index.php (Redirect to Public Login)
└── tuc_voting.sql (Database Schema)
```

### 2. Database Setup

1.  **Create Database:** Create a new MySQL database named `tuc_voting_db`.
    ```sql
    CREATE DATABASE tuc_voting_db;
    ```
2.  **Import Schema:** Import the provided schema file into the new database.
    ```bash
    mysql -u your_username -p tuc_voting_db < tuc_voting.sql
    ```
    The `tuc_voting.sql` file includes all necessary tables (`users`, `voters`, `positions`, `candidates`, `votes`, `settings`) and initial data.

### 3. Configuration

Edit the database connection details in `includes/db.php`:

```php
// includes/db.php

// Database credentials - REPLACE WITH YOUR ACTUAL CREDENTIALS
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'root'); // <-- Change this
define('DB_PASSWORD', 'password'); // <-- Change this
define('DB_NAME', 'tuc_voting_db');
```

### 4. Initial Login Credentials

The system is pre-populated with initial users for testing.

| Portal | Role | Username/ID | Password | Notes |
| :--- | :--- | :--- | :--- | :--- |
| **Admin** | Super Admin | `admin@tuc.com` | `admin123` | Access all admin features. |
| **Public** | Sample Voter | `VOTER001` | `TUC2025` | Use the common password. |
| **Public** | Sample Voter | `VOTER002` | `TUC2025` | Use the common password. |

**Important Security Note:** The common voter password hash (`$2y$10$xcui0kE4CtS/OO.nRbRkbeJRFfAfeCqcx5LFRw9KqvyXSL8O9z00O` for "TUC2025") is stored in the `settings` table and `includes/db.php`. You can change the common password by updating the hash in the `settings` table.

## Access Points

*   **Public Portal (Voter):** `http://your-domain/tuc_voting/` (Redirects to login)
*   **Admin Portal (Management):** `http://your-domain/tuc_voting/admin_login.php`

## Features Implemented

### Admin Portal
*   **Authentication:** Secure session-based login for admin users.
*   **Manage Staff (Voters):** Add single voter, bulk upload via CSV, view, edit, and delete voters.
*   **Manage Positions:** CRUD operations for election positions.
*   **Manage Candidates:** Add candidates, assign to positions, and upload photos.
*   **Manage Users:** Add, edit, and delete admin accounts (Super Admin only).
*   **Election Results:** Real-time results with total votes per candidate, breakdown by position, and winner determination. Includes a bar chart visualization.
*   **Voters Activity Log:** List of all voters, showing who has voted and the timestamp of their vote.

### Public Portal
*   **Voter Login:** Login using Staff ID and the common password.
*   **Voting:** Display all positions and candidates. Allows selection of one candidate per position.
*   **Security:** Prevents multiple voting by marking the voter as `has_voted=1` upon submission.
*   **Confirmation:** Simple receipt page after successful vote submission.
